package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Secciones;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * SeccionesDaoImpl generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class SeccionesDaoImpl implements SeccionesDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Secciones> rwMap = new RowMapper<Secciones>() {
		public Secciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Secciones(resultSet.getString("SECC004"),
					resultSet.getString("DESC004"),
					resultSet.getDate("FECHORACT004"));
		}
	};

	private RowMapper<Secciones> rwMapPK = new RowMapper<Secciones>() {
		public Secciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Secciones(resultSet.getString("SECC004"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the secciones
	 */
	public Secciones add(Secciones secciones) {
		String query = "INSERT INTO J7304S00 (SECC_004, DESC_004, FECHORACT_004) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, secciones.getSecc004(),
				secciones.getDesc004(), secciones.getFechoract004());
		return secciones;
	}

	/**
	 * Updates a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the secciones
	 */
	public Secciones update(Secciones secciones) {
		String query = "UPDATE J7304S00 SET DESC_004=?, FECHORACT_004=? WHERE SECC_004=?";
		this.jdbcTemplate.update(query, secciones.getDesc004(),
				secciones.getFechoract004(), secciones.getSecc004());
		return secciones;
	}

	/**
	 * Finds a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the secciones
	 */
	@Transactional(readOnly = true)
	public Secciones find(Secciones secciones) {
		String query = "SELECT t1.SECC_004 SECC004, t1.DESC_004 DESC004, t1.FECHORACT_004 FECHORACT004 FROM J7304S00 t1  WHERE t1.SECC_004 = ?  ";

		List<Secciones> seccionesList = this.jdbcTemplate.query(query,
				this.rwMap, secciones.getSecc004());
		return (Secciones) DataAccessUtils.uniqueResult(seccionesList);
	}

	/**
	 * Removes a single row in the Secciones table.
	 * 
	 *  secciones            Secciones
	 *
	 * @param secciones the secciones
	 */
	public void remove(Secciones secciones) {
		String query = "DELETE FROM J7304S00 WHERE SECC_004=?";
		this.jdbcTemplate.update(query, secciones.getSecc004());
	}

	/**
	 * Finds a list of rows in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Secciones> findAll(Secciones secciones,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_004 SECC004,t1.DESC_004 DESC004,t1.FECHORACT_004 FECHORACT004 ");
		query.append("FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(secciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Secciones>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Secciones table using like.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Secciones> findAllLike(Secciones secciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_004 SECC004,t1.DESC_004 DESC004,t1.FECHORACT_004 FECHORACT004 ");
		query.append("FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Secciones>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Long
	 *
	 * @param secciones the secciones
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Secciones secciones) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(secciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Secciones table using like.
	 * 
	 *  secciones
	 *            Secciones
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param secciones the secciones
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Secciones secciones, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Secciones selected for rup_table.
	 * 
	 *  secciones            Secciones
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Secciones>>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Secciones>> reorderSelection(Secciones secciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.SECC_004 SECC004,t1.DESC_004 DESC004,t1.FECHORACT_004 FECHORACT004 ");
		// FROM
		query.append("FROM J7304S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Secciones.class, filterParamList,
				"SECC_004");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Secciones>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Secciones entity.
	 * 
	 *  secciones            Secciones Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param secciones the secciones
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Secciones secciones) {

		StringBuilder where = new StringBuilder(
				SeccionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (secciones != null && secciones.getSecc004() != null) {
			where.append(" AND t1.SECC_004 = ?");
			params.add(secciones.getSecc004());
		}
		if (secciones != null && secciones.getDesc004() != null) {
			where.append(" AND t1.DESC_004 = ?");
			params.add(secciones.getDesc004());
		}
		if (secciones != null && secciones.getFechoract004() != null) {
			where.append(" AND t1.FECHORACT_004 = ?");
			params.add(secciones.getFechoract004());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Secciones entity.
	 * 
	 *  secciones            Secciones Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param secciones the secciones
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Secciones secciones,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SeccionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (secciones != null && secciones.getSecc004() != null) {
			where.append(" AND UPPER(t1.SECC_004) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secciones.getSecc004().toUpperCase() + "%");
			} else {
				params.add("%" + secciones.getSecc004().toUpperCase() + "%");
			}
			where.append(" AND t1.SECC_004 IS NOT NULL");
		}
		if (secciones != null && secciones.getDesc004() != null) {
			where.append(" AND UPPER(t1.DESC_004) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secciones.getDesc004().toUpperCase() + "%");
			} else {
				params.add("%" + secciones.getDesc004().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_004 IS NOT NULL");
		}
		if (secciones != null && secciones.getFechoract004() != null) {
			where.append(" AND t1.FECHORACT_004 = ?");
			params.add(secciones.getFechoract004());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
